/*******************************************************
FileName	  :  ws_station_view.sql 
Author		  :  Sree Rayankula  
Date		  :  05/16/2007 
Description	  :  creates lws_station_view, ssue necessary 
			  	 grants to storetweb 
Assumption	  :  STORET Datawarehouse schemata and its 
			  	 objects are created on the database server. 
Comments	  :  
*******************************************************/ 

spool station_view.log
set serveroutput on;

PROMPT Creating View WS_STATION_VIEW
CREATE OR REPLACE FORCE VIEW WS_STATION_VIEW
 AS SELECT sd.PK_ISN PkISNIdentifier,
	sd.ORGANIZATION_ID OrganizationIdentifier,
	org.ORGANIZATION_NAME OrganizationFormalName,
	sd.STATION_ID StationIdentifier,
	sd.STATION_NAME as StationName,
	st.PRIMARY_TYPE PrimaryTypeName,
    st.SECONDARY_TYPE SecondaryTypeName,
	sd.WELL_NUMBER WellNumber,
	sd.PIPE_NUMBER PipeNumber,
	sd.LOCATION_POINT_TYPE LocationPointTypeName,
	sd.POINT_SEQUENCE_NUMBER PointSequenceNumber,
	sd.STD_LATITUDE LatitudeMeasure,
	sd.STD_LONGITUDE LongitudeMeasure,
	hd.ID_CODE HorizontalReferenceDatumCode,
	hd.HORIZONTAL_DATUM HorizontalReferenceDatumName,
	hm.GEOPOSITIONING_METHOD HorizontalCollectionMethodText,
	sd.MAP_SCALE SourceMapScaleNumber,
	sd.ELEVATION VerticalMeasure,
	vd.ID_CODE VerticalReferenceDatumCode,
	vd.ELEVATION_DATUM VerticalReferenceDatumName,
	vm.ELEVATION_METHOD VerticalCollectionMethodText,
	gs.COUNTRY_NAME CountryName,
	gs.STATE_NAME StateName,
	gc.COUNTY_NAME CountyName,
	sd.HYDROLOGIC_UNIT_CODE HydrologicUnitCode,
	ca.HYDROLOGIC_UNIT_NAME HydrologicUnitName,
	sd.RF1_SEGMENT_CODE RF1SegmentCode,
	sd.RF1_SEGMENT_NAME RF1SegmentName,
	sd.RF1_MILEAGE RF1MileageMeasure,
	sd.ON_REACH_IND OnReachIndicator,
	sd.NRCS_WATERSHED_ID NRCSWatershedIdentifier,
	ep.PRIMARY_ESTUARY PrimaryEstuaryName,
	es.SECONDARY_ESTUARY SecondaryEstuaryName,
	sd.OTHER_ESTUARY_NAME OtherEstuaryName,
	sd.GREAT_LAKE_NAME GreatLakeName,
	sd.OCEAN_NAME OceanName,
	sd.NATV_AMERICAN_LAND_NAME NativeAmericanLandName,
	sd.FRS_KEY_IDENTIFIER FRSKeyIdentifier,
	sd.SGO_INDICATOR StationSGOIndicator
FROM FA_STATION sd,
	DI_ORG org,
	DI_STATN_TYPES st,
	LU_MAD_HDATUM hd,
	LU_MAD_HMETHOD hm,
	LU_MAD_VDATUM vd,
	LU_MAD_VMETHOD vm,
	DI_GEO_STATE gs,
	DI_GEO_COUNTY gc,
	DI_DB_CAT ca,
	LU_ESTRY_PRIMARY ep,
	LU_ESTRY_SECONDARY es 
WHERE 
	sd.FK_ORG = org.PK_ISN (+) AND
	FK_STATN_TYPES = st.PK_ISN (+)AND 
	FK_MAD_HDATUM = hd.PK_ISN (+) AND 
	FK_MAD_HMETHOD = hm.PK_ISN (+) AND
	sd.FK_MAD_VDATUM = vd.PK_ISN (+) AND
	sd.FK_MAD_VMETHOD = vm.PK_ISN (+) AND
	sd.FK_GEO_STATE = gs.PK_ISN (+) AND
	sd.FK_GEO_COUNTY = gc.PK_ISN(+) AND
	sd.FK_DB_CAT = ca.PK_ISN (+) AND
	sd.FK_ESTRY_PRIMARY = ep.PK_ISN (+) AND
   	sd.FK_ESTRY_SECONDARY = es.PK_ISN (+) AND
	sd.LOCATION_POINT_TYPE = '*POINT OF RECORD' AND
	sd.STATION_VISITED = 'YES';

begin

begin  
--indexes on std_latitude, std_longitude, location_point_type are already created 
--create indexes on fa_station 
execute immediate 'drop index IWS_BITMAP_FA_STATION_VISITED';
exception when others then null;
end;

begin
execute immediate 'create bitmap index IWS_BITMAP_FA_STATION_VISITED on FA_STATION (STATION_VISITED) ' ||
				  'tablespace storetindx ' ||
				  'storage (initial 2M next 2M)';
exception when others then null;
end;

-- Issue select grant to storetweb 
execute immediate 'grant select on ws_station_view to storetweb';
end;
/

spool off;

